$(document).ready(function() {
    function toggleNavbarForMobile() {
        if ($(window).width() <= 767) {
            $('.navbar-toggler').click(function() {
                $('.navbar-collapse').toggleClass('collapse');
            });
        } else {
            $('.navbar-collapse').removeClass('collapse');
        }
    }
    toggleNavbarForMobile();
    $(window).resize(function() {
        toggleNavbarForMobile();
    });
});
// 
// 
document.addEventListener("DOMContentLoaded", function () {
  const popup = document.querySelector(".popup-outer");
	
  if (!popup) return; 

  const offer = document.querySelector(".special-offer");
  const thankyou = document.querySelector(".thnku-msg");
  const closeMsg = document.querySelector(".close-msg");
  const noThanks = document.querySelector(".no-thnks");
  const body = document.querySelector("body");

  
  setTimeout(() => {
    popup.classList.add("active");
    offer.classList.add("active");
    thankyou.classList.remove("active");
    closeMsg.classList.remove("active");
    noThanks.classList.remove("active");
    body.classList.add("enable-popup");
  }, 100);
 
  document.querySelectorAll(".popup-outer .close-icon:not(.link-whatsup)").forEach(el => {
    el.addEventListener("click", () => {
      popup.classList.remove("active");
      body.classList.remove("enable-popup");
    });
  });
 
  document.querySelector(".close-icon.link-whatsup")?.addEventListener("click", function (e) {
    e.preventDefault();
    offer.classList.remove("active");
    thankyou.classList.remove("active");
    noThanks.classList.remove("active");
    closeMsg.classList.add("active");
  });
 
  document.querySelector("span.close-pop")?.addEventListener("click", function () {
    offer.classList.remove("active");
    thankyou.classList.remove("active");
    closeMsg.classList.remove("active");
    noThanks.classList.add("active");
  });
 
  document.querySelector(".not-intr")?.addEventListener("click", function () {
    popup.classList.remove("active");
    body.classList.remove("enable-popup");
  });
 
  window.addEventListener("message", function (event) {
    if (event.data.type === "hsFormCallback" && event.data.eventName === "onFormSubmitted") {
      offer.classList.remove("active");
      closeMsg.classList.remove("active");
      noThanks.classList.remove("active");
      thankyou.classList.add("active");
    }
  });
});

// 


$(window).on('load', function() {
    var $menu = $('.navbar-nav');
    var $items = $menu.find('.menu_item');
    new SlidingMenu({
      'menu': $menu,
      'items': $items,
      'duration': 300,
      'slidingClass': 'type-line'
    });
    function over(current, data) {
      $(data.options.items).removeClass('active');
      $(current).addClass('active');
    }
    function leave(current, data) {
      $(data.options.items).removeClass('active');
      $(data.itemActive).addClass('active');
    }
    var $jsFromGithub = $('.js-form-github');
    $(window).on('scroll', function() {
      if ($(window).scrollTop() > 200) {
        $jsFromGithub.stop().animate({
          'bottom': 0
        }, 200);
      } else {
        $jsFromGithub.stop().animate({
          'bottom': -65
        }, 200);
      }
    });
  });
