<?php

add_action( 'wp_enqueue_scripts', 'basel_child_enqueue_styles_and_scripts', 1000 );

function basel_child_enqueue_styles_and_scripts() {
    $version = basel_get_theme_info( 'Version' );
    
    // Enqueueing Stylesheets
    if( basel_get_opt( 'minified_css' ) ) {
        wp_enqueue_style( 'basel-style', get_template_directory_uri() . '/style.min.css', array('bootstrap'), $version );
    } else {
        wp_enqueue_style( 'basel-style', get_template_directory_uri() . '/style.css', array('bootstrap'), $version );
    }

    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array('bootstrap'), $version );
    wp_enqueue_script( 'custom-js', get_stylesheet_directory_uri() . '/custom.js', array('jquery'), $version, null, true );
}
function enqueue_custom_google_fonts() {
    wp_enqueue_style( 'montserrat-font', 'https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap', false );
}
add_action( 'wp_enqueue_scripts', 'enqueue_custom_google_fonts' );


add_action('wp_footer', function () {
    ?>
    <script>
      document.addEventListener("DOMContentLoaded", function () {
        // Remove popup elements
        document.querySelectorAll('.mfp-wrap, .mfp-bg, .basel-popup-effect').forEach(el => el.remove());

        // Remove any class locking scroll
        document.body.classList.remove('basel-popup-open', 'mfp-active');

        // Restore scroll styles if modified
        document.body.style.overflow = 'auto';
        document.body.style.position = 'static';
      });
    </script>
    <?php
});


