<?php
/**
 * The Header template for our theme
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-04BEGN8C7X"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-04BEGN8C7X');
</script>
<meta name="google-site-verification" content="_nhKtQN0OAZglZ8Bk3dMVJqtckFPF_D3I-z6wABY6zc" />
	<link rel="stylesheet" href="https://www.starkedge.com/hs-fs/hubfs/hub_generated/module_assets/1/91182193550/1742455177940/module_Header_Module.min.css">
	<link rel="stylesheet" href="https://www.starkedge.com/hs-fs/hubfs/hub_generated/module_assets/1/91182193547/1741863787286/module_Footer_Module.min.css">
	<link rel="stylesheet" href="https://www.starkedge.com/hs-fs/hubfs/hub_generated/template_assets/1/91182193540/1741351505588/template_boostrap.min.css" type="text/css">
	<script defer src="/hs/hsstatic/HubspotToolsMenu/static-1.432/js/index.js"></script>
	<script src="https://www.starkedge.com/hubfs/starkedge-theme-2019/Files/SlidingMenu.js"></script> 
	<script src="https://js.hsforms.net/forms/v2.js" async></script>
    <script src="https://www.starkedge.com/hs-fs/hubfs/hub_generated/template_assets/1/101323375681/1742857037966/template_jquery.min.js" loading="lazy"></script>
	<script src="https://www.starkedge.com/hs-fs/hubfs/hub_generated/module_assets/1/91182193550/1742455177940/module_Header_Module.min.js"></script>
	<script src="https://www.starkedge.com/hs-fs/hubfs/hub_generated/module_assets/1/91182193547/1741863787286/module_Footer_Module.min.js"></script>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php if ( function_exists( 'wp_body_open' ) ) : ?>
	<?php wp_body_open(); ?>
<?php endif; ?>
<?php if ( basel_needs_header() ): ?>
	<?php do_action( 'basel_after_body_open' ); ?>
	<?php 
		basel_header_block_mobile_nav(); 
		$cart_position = basel_get_opt( 'cart_position' );
		if( $cart_position == 'side' || ! basel_woocommerce_installed() ) {
			?>
				<div class="cart-widget-side">
					<div class="widget-heading">
						<span class="widget-title"><?php esc_html_e( 'Shopping cart', 'basel' ); ?></span>
						<a href="#" rel="nofollow" class="widget-close"><?php esc_html_e( 'close', 'basel' ); ?></a>
					</div>
					<?php the_widget( 'WC_Widget_Cart', 'title=' ); ?>
				</div>
			<?php
		}
	?>
<?php endif ?>
<div class="website-wrapper">
<?php if ( basel_needs_header() ): ?>
	<?php if( basel_get_opt( 'top-bar' ) ): ?>
		<?php basel_enqueue_inline_style( 'header-top-bar' ); ?>
		<div class="topbar-wrapp color-scheme-<?php echo esc_attr( basel_get_opt( 'top-bar-color' ) ); ?>">
			<div class="container">
				<div class="topbar-content">
					<div class="top-bar-left">						
						<?php if( basel_get_opt( 'header_text' ) != '' ): ?>
							<?php echo do_shortcode( basel_get_opt( 'header_text' ) ); ?>
						<?php endif; ?>												
					</div>
					<div class="top-bar-right">
						<div class="topbar-menu">
							<?php 
								if( has_nav_menu( 'top-bar-menu' ) ) {
									wp_nav_menu(
										array(
											'theme_location' => 'top-bar-menu',
											'walker' => new BASEL_Mega_Menu_Walker()
										)
									);
								}
							 ?>
						</div>
					</div>
				</div>
			</div>
		</div> <!--END TOP HEADER-->
	<?php endif; ?>

	<?php
	$header_class = 'main-header';
	$header = apply_filters( 'basel_header_design', basel_get_opt( 'header' ) );
	$header_bg = basel_get_opt( 'header_background' );
	$header_has_bg = ( ! empty($header_bg['background-color']) || ! empty($header_bg['background-image']));

	$header_class .= ( $header_has_bg ) ? ' header-has-bg' : ' header-has-no-bg';
	$header_class .= ' header-' . $header;
	$header_class .= ' icons-design-' . basel_get_opt( 'icons_design' );
	$header_class .= ' color-scheme-' . basel_get_opt( 'header_color_scheme' );

	basel_enqueue_inline_style( 'header-general' );

	if ( 'vertical' === $header ) {
		basel_enqueue_inline_style( 'header-design-vertical' );
	}
	?>

	<!-- HEADER -->
	<header class="header-white-bdr">
  <div class="container">
    <div class="row main-row">
      <div class="col-12 top-header">
        <div class="row">
          <ul>
            <li><a class="phone-icn" href="tel:+12016277493"><i class="fas fa-phone"></i> +1 (201) 627-7493</a></li>
            <li><a href="mailto:info@starkedge.com"><i class="fas fa-paper-plane"></i> info@starkedge.com</a></li>
          </ul>
        </div>
      </div>
      <div class="col-12 bottom-header">
        <div class="row">
          <div class="col-12 nav-bar">
            <div class="row">
              <nav class="navbar navbar-expand-md">
                <a class="navbar-brand" href="https://www.starkedge.com/">
                  <img src="https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logowhite-new.webp?width=228&amp;height=46&amp;name=logowhite-new.webp" loading="lazy" alt="Starkedge" width="228" height="46" srcset="https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logowhite-new.webp?width=114&amp;height=23&amp;name=logowhite-new.webp 114w, https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logowhite-new.webp?width=228&amp;height=46&amp;name=logowhite-new.webp 228w, https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logowhite-new.webp?width=342&amp;height=69&amp;name=logowhite-new.webp 342w, https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logowhite-new.webp?width=456&amp;height=92&amp;name=logowhite-new.webp 456w, https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logowhite-new.webp?width=570&amp;height=115&amp;name=logowhite-new.webp 570w, https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logowhite-new.webp?width=684&amp;height=138&amp;name=logowhite-new.webp 684w" sizes="(max-width: 228px) 100vw, 228px">
                  <img class="sticky-logo" src="https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logo_coloured_new.png?width=228&amp;height=46&amp;name=logo_coloured_new.png" loading="lazy" alt="Starkedge" width="228" height="46" srcset="https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logo_coloured_new.png?width=114&amp;height=23&amp;name=logo_coloured_new.png 114w, https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logo_coloured_new.png?width=228&amp;height=46&amp;name=logo_coloured_new.png 228w, https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logo_coloured_new.png?width=342&amp;height=69&amp;name=logo_coloured_new.png 342w, https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logo_coloured_new.png?width=456&amp;height=92&amp;name=logo_coloured_new.png 456w, https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logo_coloured_new.png?width=570&amp;height=115&amp;name=logo_coloured_new.png 570w, https://www.starkedge.com/hs-fs/hubfs/starkedge-theme-2019/Images/Home-page/logo_coloured_new.png?width=684&amp;height=138&amp;name=logo_coloured_new.png 684w" sizes="(max-width: 228px) 100vw, 228px">
                </a>
                <button class="navbar-toggler mobile-toggle" type="button" data-toggle="collapse" data-target="#collapsibleNavbar"> <span></span>
                  <span></span>
                  <span></span>
                </button>
                <div class="navbar-collapse navbar-right" id="collapsibleNavbar">
                  <div class="navbar-right-inner">
                    <ul class="navbar-nav clearfix">
                      <li><a class="menu_item" href="https://www.starkedge.com/">Home</a></li>
                      <li class="has-child-items"><a class="menu_item" href="javascript:;">Services</a>
                        <ul class="child-items" style="display:none;">
                          <li class="has-child-items"><a class="menu_item" href="javascript:;">Frontend</a>
                            <ul class="child-items" style="display:none;">
                              <li><a href="https://www.starkedge.com/paradot">Pardot</a></li>
                              <li><a href="https://www.starkedge.com/unbounce">Unbounce</a></li>
                              <li><a href="https://www.starkedge.com/hire-frond-end-developer">JS Frameworks</a></li>
                            </ul>
                          </li>
                          <li class="has-child-items"><a class="menu_item" href="javascript:;">Web &amp; Graphics</a>
                            <ul class="child-items" style="display:none;">
                              <li><a href="https://www.starkedge.com/ul-ux?hsLang=en">UX &amp; UI Design</a></li>
                              <li><a href="https://www.starkedge.com/print-pdf?hsLang=en">Print &amp; PDF</a></li>
                            </ul>
                          </li>
                          <li class="has-child-items"><a class="menu_item" href="javascript:;">Web  Development</a>
                            <ul class="child-items" style="display:none;">
                              <li><a href="https://www.starkedge.com/php?hsLang=en">PHP</a></li>
                            </ul>
                          </li>
                          <li class="has-child-items"><a class="menu_item" href="javascript:;">E-commerce/CMS</a>
                            <ul class="child-items" style="display:none;">
                              <li><a href="https://www.starkedge.com/shopify?hsLang=en">shopify</a></li>
                              <li><a href="https://www.starkedge.com/wordpress?hsLang=en">WordPress</a></li>
                              <li><a href="https://www.starkedge.com/hubspot-development-company">Hubspot</a></li>
                            </ul>
                          </li>
                          <li class="has-child-items"><a class="menu_item" href="javascript:;">Digital marketing</a>
                            <ul class="child-items" style="display:none;">
                              <li><a href="https://www.starkedge.com/seo?hsLang=en">SEO</a></li>
                              <li><a href="https://www.starkedge.com/smm?hsLang=en">SMM</a></li>
                              <li><a href="https://www.starkedge.com/ppc?hsLang=en">PPC</a></li>
                              <li><a href="https://www.starkedge.com/cro?hsLang=en">CRO</a></li>
                            </ul>
                          </li>
                          <li class="has-child-items"><a class="menu_item" href="javascript:;">Mobile</a>
                            <ul class="child-items" style="display:none;">
                              <li><a href="https://www.starkedge.com/ios-app?hsLang=en">iphone</a></li>
                              <li><a href="https://www.starkedge.com/hybrid-app?hsLang=en">Hybrid</a></li>
                              <li><a href="https://www.starkedge.com/android-app?hsLang=en">Android</a></li>
                            </ul>
                          </li>
                        </ul>
                      </li>
                      <li><a class="menu_item" href="https://www.starkedge.com/portfolio">Portfolio</a></li>
                      <li><a class="menu_item" href="https://www.starkedge.com/about-us">StarkEdge</a></li>
                      <li><a class="menu_item" href="https://www.starkedge.com/blog">Blog</a></li>
                      <li><a class="menu_item" href="https://www.starkedge.com/contact-us">Contact</a></li>
                      <div id="marker"></div>
                    </ul>
                    <div class="request-btn">
                      <a class="request-header-btn hdr_popup_btn" href="javascript:;">Request A QUOTE</a>
                      <a class="sticky-request-btn gradient-btn hdr_popup_btn" href="javascript:;">Request A QUOTE</a>
                    </div>
                  </div>
                </div>
              </nav>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-12 dropdown-header-outer" style="display: none;">
    <div class="row">
      <div class="container">
        <div class="col-12 dropdown-header-inner">
          <div class="row">
            <div class="col-md-9 dropdown-header-left">
              <div class="row align-items-start">
                <div class="dropdown-header-left">
                  <h5><img src="https://www.starkedge.com/hubfs/starkedge-theme-2019/Images/Home-page/menu-web-design.svg" loading="lazy" alt="Website Design"> Website Design</h5>
                  <ul>
                    <li><a class="dropdown-ancor" href="#"></a>
                      <h6>Frontend</h6>
                      <p>- <a href="https://www.starkedge.com/paradot">Pardot </a> | <a href="https://www.starkedge.com/unbounce">Unbounce</a> | <a href="https://www.starkedge.com/hire-frond-end-developer">JS Frameworks</a></p> 
                    </li>
                    <li><a class="dropdown-ancor" href="#"></a>
                      <h6>Web &amp; Graphics</h6>
                      <p>- <a href="https://www.starkedge.com/user-experience-optimization">UX &amp; UI Design</a> | <a href="https://www.starkedge.com/print-pdf-designer">Print &amp; PDF</a></p>
                    </li>
                  </ul>
                </div>
                <div class="dropdown-header-left">
                  <h5><img src="https://www.starkedge.com/hubfs/starkedge-theme-2019/Images/Home-page/menu-development.svg" loading="lazy" alt="Development"> development</h5>
                  <ul>
                    <li><a class="dropdown-ancor" href="#"></a>
                      <h6>Web</h6>
                      <p>- <a href="https://www.starkedge.com/php-development-company">PHP</a></p>
                    </li>
                    <li><a class="dropdown-ancor" href="#"></a>
                      <h6>E-commerce/CMS</h6>
                      <p>- <a href="https://www.starkedge.com/shopify-development-company">Shopify</a> | <a href="https://www.starkedge.com/wordpress-development-company">WordPress</a> | <a href="https://www.starkedge.com/hubspot-development-company">Hubspot</a></p> 
                    </li>
                  </ul>
                </div>
                <div class="dropdown-header-left">
                  <h5><img src="https://www.starkedge.com/hubfs/starkedge-theme-2019/Images/Home-page/menu-digital-maketing.svg" loading="lazy" alt="Digital Marketing"> Growth</h5>
                  <ul>
                    <li><a class="dropdown-ancor" href="#"></a>
                      <h6>Digital marketing</h6>
                      <p>- <a href="https://www.starkedge.com/search-engine-optimization-company">SEO</a> | <a href="https://www.starkedge.com/social-media-marketing-company">SMM</a> | <a href="https://www.starkedge.com/pay-per-click-management">PPC</a> | <a href="https://www.starkedge.com/cro">CRO</a> | <a href="https://www.starkedge.com/online-reputation-management">ORM</a></p>
                    </li>
                    <li><a class="dropdown-ancor" href="#"></a>
                      <h6>Mobile Apps</h6>
                      <p>- <a href="https://www.starkedge.com/iphone-app-development-company">Iphone</a> | <a href="https://www.starkedge.com/hybrid-app-development-company">Hybrid</a> | <a href="https://www.starkedge.com/android-app-development-company">Android</a></p>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
            <div class="col-md-3 dropdown-header-right">
              <div class="row">
                <div class="dropdown-header-right-inner">
                  <div class="dropdown-header-right-inner-top">
                    <h3>Let's Build great Things Together</h3>
                    <a class="gradient-btn" href="https://www.starkedge.com/contact-us">Get Started <i class="fal fa-arrow-right"></i></a>
                  </div>
                  <div class="dropdown-header-right-inner-bottom">
                    <h5>Or Call and Mail Us at</h5>
                    <ul>
                      <li><a href="tel:+17787455560"><i class="fal fa-phone"></i> + 1 778 745 5560</a></li>
                      <li><a href="mailto:info@starkedge.com"><i class="fal fa-envelope"></i> info@starkedge.com</a></li>
                    </ul>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>
	<div class="request-a-qoute-outer new-request-form">
  <div class="container">
    <div class="request-a-quote-inner">
      <div class="header-close-pop">
        <div class="popup-closing"><img src="https://f.hubspotusercontent20.net/hubfs/2766624/starkedge_bounce_2020/images/croos.png" loading="lazy" alt="cross"> </div>
      </div>
      <div class="request-a-quote-bottom">
        <div class="request-a-quote-left">
          <h3>We Love to hear you back</h3>
          <div class="addree-outer add-border-first">
            <div class="address-inner">
              <div class="address-1">
                <h6>Mohali Office</h6>
                <p><a href="mailto:info@starkedge.com">info@starkedge.com</a> </p>
                <p><a href="telto:+919780978098">+91 97809 78098</a></p>
              </div>
              <div class="address-2"> 
                <h6>USA office</h6>
                <p><a href="mailto:info@starkedge.com">info@starkedge.com</a></p>
                <p><a href="tel:+12016277493">+ 1 201 627 7493</a></p>
              </div>
            </div>
          </div>
          <div class="addree-outer add-border-second">
            <div class="address-inner">
              <div class="address-1">
                <h6>Contact US</h6>
                <p><a href="tel:+919780978098">+91 97809 78098</a> <br>
                <a href="tel:+12016277493">+ 1 201 627 7493</a> <br>
                  <a href="mailto:info@starkedge.com">info@starkedge.com</a></p>
              </div>
              <div class="address-2">
                <h6>HR Department</h6>
                <p><a href="tel:+911723810811">0172 3810811</a></p>
              </div>
            </div>
          </div>          
          <div class="calneder">
              <a class="calaner-outer req-btn" href="#">
              <div class="cal-image">
                <img src="https://www.starkedge.com/hs-fs/hubfs/2025/images/home/calander-image-upd.png?width=47&height=46&name=calander-image-upd.png" "lazy" width="47" height="46" alt="calender-image">
              </div>
              <div class="cal-text">
                <h4>Schedule Meeting</h4>
                <h6> Get 30-Min Free Consultation</h6>
              </div>
              </a>
          </div>
 
          <div class="request-a-quote-reviews-outer logo-row"> 
            <div class="request-a-quote-reviews-inner" style="max-width:180px">
              <div class="request-a-quote-reviews-inner-logo">
                <img src="https://www.starkedge.com/hs-fs/hubfs/2023/images/Compressed%20Image/upwork-logo-png-transparent.png?width=200&name=upwork-logo-png-transparent.png" "lazy" alt="Logo" width="100">
                <a href="#">245 Reviews</a> 
              </div>
              <div class="star"> <span>4.8</span><img src="https://cdn2.hubspot.net/hubfs/2766624/starkedge-theme-2019/Images/Home-page/5star-popup.svg" loading="lazy" alt="Star" width="59" height="7"> </div>
            </div>
            <div class="clutch-logo">
              <img src="https://2766624.fs1.hubspotusercontent-na1.net/hubfs/2766624/2025/images/shopify/clutch-3.svg" alt="clutch logo">
            </div>          
          </div>   
        </div>
        <div class="request-a-quote-right">
          <h2>Send us your requirements and get a quote!</h2> 
          <script charset="utf-8" type="text/javascript" src="//js.hsforms.net/forms/v2.js"></script>
          <script>
            hbspt.forms.create({
              portalId: "2766624",
              formId: "3e874c58-6500-4b08-9ddf-116f2f802281",
              css:""
            });
          </script>
        </div>
      </div>
    </div>
  </div>
	<div class="popup_content calendly-popup">
      <div class="iframe_block">        
        <div class="meetings-iframe-container" data-src="https://www.starkedge.com/meetings/stark-edge/shopify?embed=true"><div class="popup_close">
          <svg xmlns="http://www.w3.org/2000/svg" width="38" height="38" viewBox="0 0 38 38" fill="none">
            <circle cx="19" cy="19" r="19" fill="#002248"></circle>
            <path d="M12 12L25.641 25.641" stroke="white" stroke-width="2" stroke-linecap="round"></path>
            <path d="M25.6406 12L11.9996 25.641" stroke="white" stroke-width="2" stroke-linecap="round"></path>
          </svg>
        </div></div>
      </div> 
      <script type="text/javascript" src="https://static.hsappstatic.net/MeetingsEmbed/ex/MeetingsEmbedCode.js"></script>
    </div>
 
<script>
  document.addEventListener("DOMContentLoaded", function () {
    const btns = document.querySelectorAll(".req-btn");
    const popup = document.querySelector(".calendly-popup");
    const closeBtn = document.querySelector(".popup_close");
    const body = document.body;
 
    if (btns.length > 0 && popup) {
      btns.forEach(function (btn) {
        btn.addEventListener("click", function (e) {
          e.preventDefault();
          popup.style.display = "block"; 
          body.classList.add("popup-open"); 
        });
      });
    }
 
    if (closeBtn) {
      closeBtn.addEventListener("click", function () {
        popup.style.display = "none"; 
        body.classList.remove("popup-open"); 
      });
    }
  });
</script>
</div>
	<!--END MAIN HEADER-->

	<div class="clear"></div>
	
	<?php basel_page_top_part(); ?>
<?php endif ?>
