<?php
/**
 * Pagination - Show numbered pagination for catalog pages
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/pagination.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 9.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wp_query;

$total   = isset( $total ) ? $total : wc_get_loop_prop( 'total_pages' );
$current = isset( $current ) ? $current : wc_get_loop_prop( 'current_page' );
$base    = isset( $base ) ? $base : esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
$format  = isset( $format ) ? $format : '';

if ( $total <= 1 ) {
	return;
}

$pagination = basel_get_opt( 'shop_pagination' );

# fix bug with wrong escaped url generated by next_posts() call
if( is_search() ) {
	$pagination = 'pagination';
}

?>
<div class="products-footer">
	<?php if ( $pagination == 'more-btn' || $pagination == 'infinit' ): ?>
		<?php basel_enqueue_inline_style( 'mod-load-more-button' ); ?>
		<?php if( get_next_posts_link() ) : ?>
			<a href="<?php echo next_posts( $wp_query->max_num_pages, false ); ?>" rel="nofollow" class="btn basel-load-more basel-products-load-more load-on-<?php echo 'more-btn' == $pagination ? 'click' : 'scroll'; ?>"><?php esc_html_e('Load more products', 'basel'); ?></a>
			<span class="btn basel-load-more basel-load-more-loader"><?php esc_html_e('Load more products', 'basel'); ?></span>
		<?php endif; ?>
	<?php else: ?>
	<nav class="woocommerce-pagination" aria-label="<?php esc_attr_e( 'Product Pagination', 'woocommerce' ); ?>">
		<?php
			echo paginate_links( apply_filters( 'woocommerce_pagination_args', array(
				'base'         => $base,
				'format'       => $format,
				'add_args'     => false,
				'current'      => max( 1, $current ),
				'total'        => $total,
				'prev_text'    => '&larr;',
				'next_text'    => '&rarr;',
				'type'         => 'list',
				'end_size'     => 3,
				'mid_size'     => 3,
			) ) );
		?>
	</nav>
	<?php endif ?>
</div>
